function d_n = fault_slip_cheb_coeff_delta(ddelta_dy_hat,N,T,y_minus_cross,y_plus_cross)
%
% Computes the coefficients d_n for an expansion of the slip gradient ddelta_dxi in 
% first-kind Chebyshev polynomials. 
%
z_hat_j = -cos( pi*((1:N)-0.5)/N ); % first-kind Chebyshev points, -1 < z_j < 1 
ddelta_dy_hat_j = zeros(1,N);
M = length(ddelta_dy_hat);
if (y_minus_cross + y_plus_cross) < 0 % bottom patch is cross patch
    ddelta_dy_hat_j(1:M) = ddelta_dy_hat; 
else % top patch is cross patch
    ddelta_dy_hat_j(end-M+1:end) = ddelta_dy_hat;     
end
d_n = ( (2/(N+1)) * sqrt(1-z_hat_j.^2) .* ddelta_dy_hat_j * T )'; % computes Chebyshev coeff.


